* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* The wage data comes from the Social Security Administration's 
* National Average Wage Index
* https://www.ssa.gov/oact/cola/awiseries.html
* Accessed May 19th 2019
import delimited "$datapath/SSA_wages.csv", clear 
ren *year fyear
ren awi wage_ind
compress
save tmp1.dta, replace

* The other two series are
* Gross private domestic investment: Fixed investment: Nonresidential (implicit price deflator)
* Gross Domestic Product: Implicit Price Deflator
* They can be downloaded from FRED
import fred A008RD3A086NBEA GDPDEF, aggregate(annual) clear
tsmktim fyear, start(1929)
ren A nonres_ind
ren G gdp_ind
drop dates daten
order fyear
drop if fyear < 1951 | fyear > 2018
compress

* Merge with wage data
merge 1:1 fyear using tmp1.dta, nogen
save "$datapath/prices_updated.dta", replace

erase tmp1.dta

